/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.network;

import com.alexander.mutantmore.capabilities.MutantShulkerShieldShootTimerProvider;
import com.alexander.mutantmore.config.MutantShulkerShieldCommonConfig;
import com.alexander.mutantmore.init.SoundEventInit;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantShulkerShieldShootAnimationStartPacket {
    private final int entityID;
    private final ItemStack item;
    private final int animation;

    public MutantShulkerShieldShootAnimationStartPacket(int entityID, ItemStack item, int animation) {
        this.entityID = entityID;
        this.item = item;
        this.animation = animation;
    }

    public MutantShulkerShieldShootAnimationStartPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.item = buf.m_130267_();
        this.animation = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130055_(this.item);
        buf.writeInt(this.animation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            LivingEntity entityHolding = (LivingEntity)player.f_19853_.m_6815_(this.entityID);
            if (!entityHolding.f_19853_.f_46443_) {
                entityHolding.getCapability(MutantShulkerShieldShootTimerProvider.MUTANT_SHULKER_SHIELD_SHOOT_TIMER).ifPresent(data -> {
                    if (data.getTime() <= 0) {
                        ItemStack stack = entityHolding.m_21120_(entityHolding.m_7655_());
                        int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)stack, (ServerLevel)((ServerLevel)entityHolding.m_9236_()));
                        PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entityHolding);
                        GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)((ISyncable)this.item.m_41720_()), (int)id, (int)this.animation);
                        stack.m_41622_(3, entityHolding, p_40858_ -> p_40858_.m_21190_(entityHolding.m_7655_()));
                        if (entityHolding instanceof Player) {
                            ((Player)entityHolding).m_36335_().m_41524_(stack.m_41720_(), ((Integer)MutantShulkerShieldCommonConfig.shoot_cooldown.get()).intValue());
                        }
                        entityHolding.f_19853_.m_5594_(null, entityHolding.m_20183_(), (SoundEvent)SoundEventInit.MUTANT_SHULKER_SHIELD_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        data.setTime(23);
                    }
                });
            }
        });
        return true;
    }
}

